//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.Controls 1.0
import wesual.Ui       1.0

import wesual.data.Core 1.0

Dialog {
    id : typePicker

    property alias type          : typeListing.type
    property alias context       : typeListing.context

    readonly property int numberOfTypes : typeListing.documents.length

    PersistentTypeListing {
        id : typeListing
    }

    contentWidth  : 275
    contentHeight : 300

    label         : qsTrId("258b709465c58591")

    delegate : ScrollView {
        id : scrollView

        anchors.fill : parent

        Column {
            width  : scrollView.width - 2
            height : implicitHeight

            Repeater {
                model : typeListing.documents
                delegate : Rectangle {

                    readonly property bool current :
                        typePicker.result === modelData

                    width  : parent.width
                    height : 30

                    color : current ?
                                UiColors.getColor(UiColors.SelectionGreen) :
                                      mouseArea.containsMouse ?
                                    UiColors.getColor(UiColors.HoverGreen) :
                                    UiColors.getColor(UiColors.White)



                    Text {
                        anchors {
                            left : parent.left
                            leftMargin : 6
                            rightMargin : 6
                            verticalCenter : parent.verticalCenter
                        }
                        text : modelData.label

                        font : UiFonts.getFont(UiFonts.Light, 14)

                        color : current ?
                                    UiColors.getColor(UiColors.White) :
                                    UiColors.getColor(UiColors.Black)
                    }

                    MouseArea {
                        id : mouseArea

                        anchors.fill : parent

                        hoverEnabled : true

                        onClicked    : typePicker.result = modelData
                    }
                }
            }
        }
    }
}
